/*
Copyright 2008 ToastFreeware (Philipp Spitzer, Gregor Herrmann)

This file is part of Pocketlamp.

Pocketlamp is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option)
any later version.

Pocketlamp is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.
                    
You should have received a copy of the GNU General Public License along with
Pocketlamp. If not, see <http://www.gnu.org/licenses/>.

*/

package at.priv.toastfreeware.pocketlamp;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.SubMenu;
import android.view.Window;
import android.view.Menu.Item;


public class PocketLamp extends Activity {
	private PocketLampView pocketLampView;
	Item miModeStatic;
	Item miModeInteractive;
	Item miModeBlink;
	Item miColorWhite;
	Item miColorRed;
	Item miColorGreen;
	Item miColorBlue;
	Item miColorMagenta;
	Item miColorCyan;
	Item miColorYellow;
	Item miColorOrange;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);

		// Turn off the title bar
		requestWindowFeature(Window.FEATURE_NO_TITLE);

		setContentView(R.layout.main);
		pocketLampView = (PocketLampView) findViewById(R.id.pocketlamp);
		pocketLampView.setMode(PocketLampView.Mode.STATIC);
	}


	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);
		
		miModeStatic = menu.add(0, 0, R.string.menu_mode_static, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.STATIC);}});
		miModeInteractive = menu.add(0, 0, R.string.menu_mode_interactive, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.INTERACTIVE);}});
		miModeBlink = menu.add(0, 0, R.string.menu_mode_blink, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.BLINK);}});
		menu.addSeparator(0, 0);
		SubMenu subMenu = menu.addSubMenu(0, 0, R.string.menu_color);
		miColorWhite = subMenu.add(10, 0, R.string.menu_color_white, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.white));}});
		miColorRed = subMenu.add(10, 0, R.string.menu_color_red, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.red));}});
		miColorGreen = subMenu.add(10, 0, R.string.menu_color_green, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.green));}});
		miColorBlue = subMenu.add(10, 0, R.string.menu_color_blue, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.blue));}});
		miColorMagenta = subMenu.add(10, 0, R.string.menu_color_magenta, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.magenta));}});
		miColorCyan = subMenu.add(10, 0, R.string.menu_color_cyan, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.cyan));}});
		miColorYellow = subMenu.add(10, 0, R.string.menu_color_yellow, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.yellow));}});
		miColorOrange = subMenu.add(10, 0, R.string.menu_color_orange, new Runnable() {public void run() {pocketLampView.setFgColor(getResources().getColor(R. color.orange));}});
		subMenu = menu.addSubMenu(0, 0, R.string.menu_presets);
		subMenu.add(0, 0, R.string.menu_preset_bike_front, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.STATIC); pocketLampView.setFgColor(getResources().getColor(R. color.white));}});
		subMenu.add(0, 0, R.string.menu_preset_bike_back, new Runnable() {public void run() {pocketLampView.setBlinkDuration(500); pocketLampView.setMode(PocketLampView.Mode.BLINK); pocketLampView.setFgColor(getResources().getColor(R. color.red));}});
		subMenu.add(0, 0, R.string.menu_preset_warning, new Runnable() {public void run() {pocketLampView.setBlinkDuration(500); pocketLampView.setMode(PocketLampView.Mode.BLINK); pocketLampView.setFgColor(getResources().getColor(R. color.orange));}});
		subMenu.add(0, 0, R.string.menu_preset_starmap, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.INTERACTIVE); pocketLampView.setFgColor(getResources().getColor(R. color.red));}});
		subMenu.add(0, 0, R.string.menu_preset_morse, new Runnable() {public void run() {pocketLampView.setMode(PocketLampView.Mode.INTERACTIVE); pocketLampView.setFgColor(getResources().getColor(R. color.white));}});
		
		miModeStatic.setCheckable(true);
		miModeInteractive.setCheckable(true);
		miModeBlink.setCheckable(true);
		
		miColorWhite.setCheckable(true);
		miColorRed.setCheckable(true);
		miColorGreen.setCheckable(true);
		miColorBlue.setCheckable(true);
		miColorMagenta.setCheckable(true);
		miColorCyan.setCheckable(true);
		miColorYellow.setCheckable(true);
		miColorOrange.setCheckable(true);
		
		return true;
	}


	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		miModeStatic.setChecked(pocketLampView.getMode() == PocketLampView.Mode.STATIC);
		miModeInteractive.setChecked(pocketLampView.getMode() == PocketLampView.Mode.INTERACTIVE);
		miModeBlink.setChecked(pocketLampView.getMode() == PocketLampView.Mode.BLINK);
		miColorWhite.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.white));
		miColorRed.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.red));
		miColorGreen.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.green));
		miColorBlue.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.blue));
		miColorMagenta.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.magenta));
		miColorCyan.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.cyan));
		miColorYellow.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.yellow));
		miColorOrange.setChecked(pocketLampView.getFgColor() == getResources().getColor(R. color.orange));
		return super.onPrepareOptionsMenu(menu);
	}


}
