#include <QMessageBox>
#include <QFile>
#include <QTextStream>
#include "options.h"

OptionsDialog::OptionsDialog(QWidget *parent): QDialog(parent) {
	setupUi(this);

	QString helpText = labHelp->text();
	helpText.append("<ul>");
	helpText.append("<li>${d}: " + tr("day of month") + " (01-31)</li>");
	helpText.append("<li>${m}: " + tr("month") + " (01-12)</li>");
	helpText.append("<li>${y}: " + tr("year (last two digits)") + " </li>");
	helpText.append("<li>${Y}: " + tr("year (4 digits)") + " </li>");
	helpText.append("<li>${dow_DE}: " + tr("day of week in German") + " (Montag, ...)</li>");
	helpText.append("</ul>");
	labHelp->setText(helpText);
}


bool OptionsDialog::exec(const QString& configFile) {
	if (configFile.isEmpty()) {
		QMessageBox::warning(this, tr("No user config file location"), tr("The location of the user config file could not be determined."));
		return false;
	}
	QFile configFileUser(configFile);
	if (!configFileUser.exists()) {
		#if QT_VERSION >= 0x040200
		QMessageBox::StandardButton answer = QMessageBox::question(this, tr("Create user config file?"), tr("The user config file %1 does not exist. Do you want to create it?").arg(configFile), QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel, QMessageBox::Yes);
		if (answer != QMessageBox::Yes) return false;
		#else
		int answer = QMessageBox::question (this, tr("Create user config file?"), tr("The user config file %1\n" "does not exist. Do you want to create it?").arg(configFile), QMessageBox::Ok, QMessageBox::Cancel);
		if (answer != 1) return false;
		#endif
		teIni->clear();
	} else {
		if (!configFileUser.open(QIODevice::ReadOnly | QIODevice::Text)) {
			QMessageBox::warning(this, tr("File not readable"), tr("The user config file %1 is not readable.").arg(configFile));
			return false;
		}
		QTextStream in(&configFileUser);
		while (!in.atEnd()) teIni->append(in.readLine());
		#if QT_VERSION >= 0x040200
		teIni->moveCursor(QTextCursor::Start);
		#else
		// 
		#endif
	}
	configFileUser.close();
	if (QDialog::exec() == QDialog::Accepted) {
		if (!teIni->document()->isModified()) return false;
		// Save
		if (!configFileUser.open(QIODevice::WriteOnly | QIODevice::Text)) {
			QMessageBox::warning(this, tr("File not writeable"), tr("The config file %1 is not writeable.").arg(configFile));
			return false;
		}
		QTextStream out(&configFileUser);
		out << teIni->toPlainText();
		return true;
	}
	return false;
}

