#!/usr/bin/perl -w
#
# Copyright and License:
#
# Copyright (C) 2007-2009
# gregor herrmann <gregor+debian@comodo.priv.at>,
# Philipp Spitzer <philipp@spitzer.priv.at>
#
# This program is free software; you can redistribute it and/or modify it   
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA, or point
# your browser to http://www.gnu.org/licenses/gpl.html

use strict;
use Config::IniFiles;
use DateTime;

sub error {
	my $msg = shift(@_);
	print "$msg\n";
	exit(1);
}

# variables
my $configfile;
if (-r "$ENV{HOME}/.teleschorschrc") {
	$configfile = "$ENV{HOME}/.teleschorschrc";
} elsif (-r "/etc/teleschorschrc") {
	$configfile = "/etc/teleschorschrc";
} else {
	error "Neiter /etc/teleschorschrc nor $ENV{HOME}/.teleschorschrc found";
}

my $defaultdate;
if (DateTime->now->hour < 12) {
	$defaultdate = DateTime->now->subtract(days => 1)->dmy(' ');
} else {
	$defaultdate = DateTime->now->dmy(' ');
}

my %playeroptions = ("vlc" => "--start-time", "gmplayer" => "-cache 512 -ss");

# read config
my %cfg;
tie %cfg, 'Config::IniFiles', ( -file => $configfile, -allowcontinue => 1) 
	or error "Can't read $configfile: $!";
my @channels = sort keys %cfg;

sub create_list {	
	my $result;
	foreach my $c (@channels) {
		$result .= "$c '$cfg{$c}{'FULLNAME'}' off ";
	}
	return $result;
}

# call xdialog
my $channellist = &create_list;
my @args=("Xdialog --stdout --title 'TeleSchorsch' --no-tags --radiolist 'Choose your preferred stream:' 0 0 0 $channellist --calendar 'Date' 0 0 $defaultdate --timebox 'Offset\n(Start at beginning of stream: 0:0:0, start at position 3 minutes: 0:3:0, ...)' 0 0 0 0 0");
my $selection = qx/@args/ or error "@args: $? // $!\n\n";
my ($stream, $date, $offset) = split (/\n/, $selection);

# manipulate results
my ($hours, $minutes, $seconds) = split(/:/, $offset);
my $offsetseconds = $hours * 3600 + $minutes * 60 + $seconds;

my ($day, $month, $year) = split(/\//, $date);
my $dt = DateTime->new(year => $year, month => $month, day => $day);
my $y =  $dt->strftime("%y");
my $Y =  $dt->strftime("%Y");
my $m =  $dt->strftime("%m");
my $d =  $dt->strftime("%d");
my $dt_DE = DateTime->from_object(object => $dt, locale => qx(locale -a | grep ^de_ | head -n 1));
my $dow_DE = $dt_DE->strftime("%A");

# get missing parameters
my $player = $cfg{$stream}{'PLAYER'};

my $url = $cfg{$stream}{'STATICURL'};
no warnings;
$url =~ s/(\${\w+?})/$1/eeg;
use warnings;

@args=("$player \"$url\" " . ${playeroptions}{$player} . " $offsetseconds");
print "Calling @args ...\n";
system (@args) == 0 
	or error "@args: $? // $!";
